/*
 * Decompiled with CFR 0.152.
 */
package sv.mh.fe.models.minec;

import sv.mh.fe.models.Llave;
import sv.mh.fe.models.minec.AlgorithmIdenitifier;
import sv.mh.fe.models.minec.Issuer;
import sv.mh.fe.models.minec.SignatureAlgorithm;
import sv.mh.fe.models.minec.Subject;
import sv.mh.fe.models.minec.SubjectPublicKeyInfo;
import sv.mh.fe.models.minec.Validity;

public class BasicEstructure {
    private String version;
    private String serial;
    private SignatureAlgorithm signatureAlgorithm;
    private Issuer issuer;
    private Validity validity;
    private Subject subject;
    private SubjectPublicKeyInfo subjectPublicKeyInfo;

    public BasicEstructure() {
    }

    public BasicEstructure(Subject subject, Llave llave) {
        this.version = "2";
        this.serial = "1.2.840.113549.1.1.11";
        this.signatureAlgorithm = new SignatureAlgorithm();
        this.issuer = new Issuer();
        this.validity = new Validity();
        this.subject = subject;
        this.subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdenitifier(llave.getAlgorithm(), null), llave.getEncodied());
    }

    public BasicEstructure(String version, String serial, SignatureAlgorithm signatureAlgorithm, Issuer issuer, Validity validity, Subject subject, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.version = version;
        this.serial = serial;
        this.signatureAlgorithm = signatureAlgorithm;
        this.issuer = issuer;
        this.validity = validity;
        this.subject = subject;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSerial() {
        return this.serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(Issuer issuer) {
        this.issuer = issuer;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public void setValidity(Validity validity) {
        this.validity = validity;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }
}

